/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6880;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.mixin.access.WeightedEntryWrapperAccess;
import potionstudios.byg.mixin.access.WeightedListAccess;

public class BYGUtil {
    public static boolean useTagReplacements = false;
    public static final ThreadLocal<class_5455> CAPTURED_REGISTRY_ACCESS = ThreadLocal.withInitial(() -> null);

    public static void captureRegistryAccess(class_5455 registryAccess) {
        CAPTURED_REGISTRY_ACCESS.set(registryAccess);
    }

    public static <V> List<List<V>> convert2DArray(V[][] arrayToConvert) {
        ArrayList<List<V>> convertedArrays = new ArrayList<List<V>>();
        for (V[] vs : arrayToConvert) {
            convertedArrays.add(Arrays.asList(vs));
        }
        return convertedArrays;
    }

    public static <T> class_5321<T>[][] _2DResourceKeyArrayTo2DList(List<List<class_5321<T>>> listToConvert) {
        ArrayList<class_5321[]> resultList = new ArrayList<class_5321[]>(listToConvert.size());
        for (List<class_5321<T>> vs : listToConvert) {
            resultList.add((class_5321[])vs.toArray(class_5321[]::new));
        }
        return (class_5321[][])resultList.toArray(x$0 -> new class_5321[x$0][]);
    }

    public static <T> String print2DResourceKeyArray(class_5321<T>[][] valueToPrint) {
        StringBuilder builder = new StringBuilder();
        for (class_5321<T>[] value : valueToPrint) {
            builder.append(Arrays.toString(Arrays.stream(value).map(class_5321::method_29177).toArray(class_2960[]::new))).append("\n");
        }
        return builder.toString();
    }

    public static <T> String dumpRegistry(class_2378<T> registry) {
        StringBuilder registryElements = new StringBuilder();
        for (int i = 0; i < registry.method_29722().size(); ++i) {
            Object object = registry.method_10200(i);
            registryElements.append(i).append(". \"").append(registry.method_10221(object).toString()).append("\"\n");
        }
        return registryElements.toString();
    }

    public static boolean createMarkerFile(Path path, String markerText) {
        if (path.toFile().exists()) {
            return false;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, markerText.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNearby(class_4538 levelReader, class_2338 origin, int searchRange, BiPredicate<class_4538, class_2338> passes) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)origin);
        for (int xOffset = -searchRange; xOffset < searchRange; ++xOffset) {
            for (int yOffset = -searchRange; yOffset < searchRange; ++yOffset) {
                for (int zOffset = -searchRange; zOffset < searchRange; ++zOffset) {
                    mutableBlockPos.method_10101((class_2382)origin).method_10100(xOffset, yOffset, zOffset);
                    if (!passes.test(levelReader, (class_2338)mutableBlockPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static IOException configFileFailureException(Path path) {
        return new IOException(String.format("BYG config found at: \"%s\" could not be read. The fastest solution is to rename this failed file and let a new file generate from BYG and replace the fields in the new file with the broken file's fields.", path.toFile()));
    }

    public static <T> class_6005<T> combineWeightedRandomLists(BiPredicate<Collection<T>, T> filter, class_6005<T> ... builders) {
        class_6005.class_6006 combinedBuilder = new class_6005.class_6006();
        for (class_6005<T> build : builders) {
            for (class_6008.class_6010 item : ((WeightedListAccess)build).byg_getItems()) {
                Object data;
                Set collection = ((WeightedListAccess)combinedBuilder.method_34974()).byg_getItems().stream().map(item1 -> ((WeightedEntryWrapperAccess)item1).byg_getData()).collect(Collectors.toSet());
                if (!filter.test(collection, data = ((WeightedEntryWrapperAccess)item).byg_getData())) continue;
                combinedBuilder.method_34975(data, ((WeightedEntryWrapperAccess)item).byg_getWeight().method_34976());
            }
        }
        return combinedBuilder.method_34974();
    }

    public static List<class_6880<class_1959>> createBiomesFromBiomeData(class_2378<class_1959> biomeRegistry, LayersBiomeData ... layersBiomeDatas) {
        ArrayList<class_6880<class_1959>> biomes = new ArrayList<class_6880<class_1959>>();
        for (LayersBiomeData layersBiomeData : layersBiomeDatas) {
            ImmutableList items = ((WeightedListAccess)layersBiomeData.biomeWeights()).byg_getItems();
            for (class_6008.class_6010 key : items) {
                class_5321 resourceKey = (class_5321)key.method_34983();
                Optional biome = biomeRegistry.method_40264(resourceKey);
                if (biome.isPresent()) {
                    biomes.add((class_6880<class_1959>)((class_6880)biome.get()));
                    continue;
                }
                BYG.LOGGER.info("\"" + resourceKey.method_29177() + "\" is not a value in the biome registry at this point, ignore this warning if the data pack containing this biome is not yet added during world creation.");
            }
        }
        return biomes;
    }

    public static String dumpCollection(Collection<String> collection) {
        String[] values = (String[])collection.toArray(String[]::new);
        StringBuilder result = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            String value = values[i];
            result.append(i + 1).append(". \"");
            if (i < length - 1) {
                result.append(value).append("\",\n");
                continue;
            }
            result.append(value).append("\"");
        }
        return result.toString();
    }

    public static <T, C, V, MAP extends Map<T, V>> MAP convertMapValueType(Map<T, C> from, Supplier<MAP> mapType, Function<C, V> newValueType) {
        Map result = (Map)mapType.get();
        from.forEach((key, oldValue) -> result.put(key, newValueType.apply(oldValue)));
        return (MAP)result;
    }

    public static boolean isInside(int minX, int minY, int maxX, int maxY, int x, int y) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public static boolean isInside(int minX, int minY, int maxX, int maxY, double x, double y) {
        return x >= (double)minX && x <= (double)maxX && y >= (double)minY && y <= (double)maxY;
    }
}

